<?php 

/**
 * @author Luiz Lucas
 * @version 1.0
 * Arquivo de inicialização do site
 */

use PHPMailer\PHPMailer\PHPMailer;

/* Definir timezone do projeto */
date_default_timezone_set('America/Fortaleza');

/* Conexão com a base do Wordpress */
$db = new \Workerman\MySQL\Connection(HOST_DB, PORT_DB, USER_DB, PASS_DB, DB_NAME);

/* Iniciando Slim Framework */
$app = new \Slim\Slim([
	'settings' => [
		'displayErrorDetails' => true,
    ]
]);

/* Iniciando Twig */
$loader = new \Twig_Loader_Filesystem(ROOT.'/views');
$twig = new \Twig_Environment( $loader, ['debug' => true, 'cache' => ROOT.'/cache', 'auto_reload' => true] );

/* Carregar funcoes do Twig */
$twig->addExtension(new Twig_Extension_Debug());
$twig->addFunction($url);
$twig->addFunction($empresa);
$twig->addFunction($empresa_site);
$twig->addFunction($usuarioLogado);
$twig->addFunction($protegePagina);

$unserialize = new Twig_SimpleFilter('unserialize', 'unserialize');
$twig->addFilter($unserialize);