<?php 
	use PHPMailer\PHPMailer\PHPMailer;
	use PHPMailer\PHPMailer\Exception;

	function renderizarView($Twig, $Dados, $View)
	{   
		$template = $Twig->loadTemplate($View.'.html');
		$template->display($Dados);
	}

	function enviarEmail($DeNome, $Para, $Assunto, $Mensagem, Array $Copias = null)
	{
		$mailer = new PHPMailer();
			$mailer -> IsSMTP(); //Habilita SMTP
			$mailer -> isHTML(true); //Habilita HTML
			$mailer -> CharSet = 'UTF-8'; //Sempre UFT-8
			$mailer -> Host = SMTP_HOST; //Host SMTP
			$mailer -> SMTPAuth = true; //Sempre true
			$mailer -> Username = SMTP_USER; //Usuario SMTP
			$mailer -> Password = SMTP_PASS; //Senha SMTP
			$mailer -> Port = SMTP_PORT; //Porta do servidor SMTP da Prolins
			$mailer -> SMTPSecure = false;
		$mailer -> SMTPAutoTLS = false;
			$mailer -> SMTPDebug = 2; //3 para Habilitar
			$mailer -> setFrom(SMTP_RECIPIENT, $DeNome); //Remetente
			$mailer -> addAddress($Para, $Assunto); //Destinatario.

			if($Copias != null) {
			foreach ($Copias as $CC) {
						$mailer -> addCC($CC, $Assunto);
				}
			}

			$mailer -> AddCustomHeader("Content-type: text/html; charset=UTF-8\r\n"); //Adiciona UTF-8 ao cabecalho
			$mailer -> Subject = $Assunto;
			$mailer -> Body = $Mensagem;

			if (!$mailer -> send())
			{
				echo "Mailer Erro: " . $mailer->ErrorInfo;
			}

			$mailer -> ClearAllRecipients();
			$mailer -> ClearAttachments();
	}

	function iniciarSessao()
	{
		session_name ( md5 ( 'seg' . $_SERVER ['REMOTE_ADDR'] . $_SERVER ['HTTP_USER_AGENT'] ) );
	}

	function protegePagina()
	{
		if (! isset ( $_SESSION ['usuarioLogado'] ) ) {
		   finalizarSessao();
		}
	}

	function validarUsuario($Usuario)
	{
		if(empty($Usuario)) {
			return false;
		} else {
			//Iniciando Sessão
			iniciarSessao();

			//Armazenando variáveis de sessão
			$_SESSION['usuarioLogado'] = true;
			$_SESSION['id_usuario'] = $Usuario['id_usuario'];
			$_SESSION['nome'] = $Usuario['nome'];
			$_SESSION['email'] = $Usuario['email'];

			return true;
		}
	}

	function finalizarSessao()
	{
		session_unset();
		header("Location:".URL);
		exit();
	}

	// Anti Injection SQL - Não mexer
	function anti_injection($string)
	{
		$string = str_ireplace ( " or ", "", $string );
		$string = str_ireplace ( "select ", "", $string );
		$string = str_ireplace ( "delete ", "", $string );
		$string = str_ireplace ( "create ", "", $string );
		$string = str_ireplace ( "drop ", "", $string );
		$string = str_ireplace ( "update ", "", $string );
		$string = str_ireplace ( "drop table", "", $string );
		$string = str_ireplace ( "show table", "", $string );
		$string = str_ireplace ( "'", "", $string );
		$string = str_replace ( "#", "", $string );
		$string = str_replace ( "=", "", $string );
		$string = str_replace ( "--", "", $string );
		$string = str_replace ( "-", "", $string );
		$string = str_replace ( ";", "", $string );
		$string = str_replace ( "*", "", $string );
		$string = strip_tags ( $string );
		$string = addslashes ( $string );

		return $string;
	}

	function gravaData($Data){
		$Data = implode("-", array_reverse(explode("/", trim($Data))));
		return $Data;
	}

	function retornaData($Data){
		$adata = new DateTime($Data);
		return $adata->format("d/m/Y");
	}

	function randomColor() {
		return "rgba(".rand(0,255).", ".rand(0,255).", ".rand(0,255).", 0.5)";
	}

	function GetMes($data) {
		$ObjData = new DateTime($data);
		$ObjData->format('m');

		$mes = "";
		switch ($ObjData->format('m')) {
			case "01":    $mes = 'Janeiro';     break;
			case "02":    $mes = 'Fevereiro';   break;
			case "03":    $mes = 'Março';       break;
			case "04":    $mes = 'Abril';       break;
			case "05":    $mes = 'Maio';        break;
			case "06":    $mes = 'Junho';       break;
			case "07":    $mes = 'Julho';       break;
			case "08":    $mes = 'Agosto';      break;
			case "09":    $mes = 'Setembro';    break;
			case "10":    $mes = 'Outubro';     break;
			case "11":    $mes = 'Novembro';    break;
			case "12":    $mes = 'Dezembro';    break; 
		}
	 
		return $mes;
	}

	function filterData(&$str) {
		$str = preg_replace("/\t/", "\\t", $str);
		$str = preg_replace("/\r?\n/", "\\n", $str);
		if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
	}

	function getSatisfacao($stf) {
		switch ($stf) {
			case 1:
				return "Muito insastifeito"; break;
			case 2:
				return "Insatisfeito"; break;
			case 3:
				return "Regular"; break;
			case 4:
				return "Satisfeito"; break;
			case 5:
				return "Muito satisfeito"; break;
			default:
				return "Erro";
				break;
		}
	}

	function getRecomenda($str)
	{
		if ($str == 1) {
			return "Sim";
		} else {
			return "Não";
		}
	}

	function verificaNA($num)
	{
		if ($num > 0) {
			return $num;
		} else {
			return "N/a";
		}
	}
?>